<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;
    protected $fillable = array('email', 'first_name', 'last_name', 'active');
    protected $visible = array('email', 'first_name', 'last_name', 'active');
    protected $hidden = array('password');

    public function counties()
    {
        return $this->belongsToMany('App\Models\County', 'user_id');
    }

    public function notification()
    {
        return $this->hasMany('App\Models\Notification', 'user_id');
    }

}